# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT::CT;
# "@(#)37   1.5   src/rsct/ext/CT/CT/CT.pm, ctcli, rsct_rpyxh, rpyxht1f3 3/11/01 17:54:43"
use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
);

@EXPORT_OK = qw(
    CT_UNKNOWN
    CT_NONE
    CT_INT32
    CT_UINT32
    CT_INT64
    CT_UINT64
    CT_FLOAT32
    CT_FLOAT64
    CT_CHAR_PTR
    CT_BINARY_PTR
    CT_RSRC_HANDLE_PTR
    CT_SD_PTR
    CT_SBS_PTR
    CT_INT32_ARRAY
    CT_UINT32_ARRAY
    CT_INT64_ARRAY
    CT_UINT64_ARRAY
    CT_FLOAT32_ARRAY
    CT_FLOAT64_ARRAY
    CT_CHAR_PTR_ARRAY
    CT_BINARY_PTR_ARRAY
    CT_RSRC_HANDLE_PTR_ARRAY
    CT_SD_PTR_ARRAY

    CT_SF_INT32
    CT_SF_FLOAT32
    CT_SF_STRING
    CT_SF_BINARY

    CT_CONTACT_IP
    CT_CONTACT_ENV_VAR
    CT_CONTACT_LOCAL
);

# use the export tags to reference enum by name
%EXPORT_TAGS = (
ct_data_type_t => [qw(
    CT_UNKNOWN
    CT_NONE
    CT_INT32
    CT_UINT32
    CT_INT64
    CT_UINT64
    CT_FLOAT32
    CT_FLOAT64
    CT_CHAR_PTR
    CT_BINARY_PTR
    CT_RSRC_HANDLE_PTR
    CT_SD_PTR
    CT_SBS_PTR
    CT_INT32_ARRAY
    CT_UINT32_ARRAY
    CT_INT64_ARRAY
    CT_UINT64_ARRAY
    CT_FLOAT32_ARRAY
    CT_FLOAT64_ARRAY
    CT_CHAR_PTR_ARRAY
    CT_BINARY_PTR_ARRAY
    CT_RSRC_HANDLE_PTR_ARRAY
    CT_SD_PTR_ARRAY
)],

ct_sbs_field_data_type_t => [qw(
    CT_SF_INT32
    CT_SF_FLOAT32
    CT_SF_STRING
    CT_SF_BINARY
)],

ct_contact_type_t => [qw(
    CT_CONTACT_IP
    CT_CONTACT_ENV_VAR
    CT_CONTACT_LOCAL
)],
);  # end %EXPORT_TAGS

# --------------------------------------------------------------------
# CT enums defined for use in PERL from ct.h
# Available Enum Definitions (constants)
# --------------------------------------------------------------------
# enums from ct.h as of 1/01/01 sccs id 1.17 1/4/01

# ct_data_type_t 
use constant CT_UNKNOWN                     => 0;
use constant CT_NONE                        => 1;
use constant CT_INT32                       => 2;
use constant CT_UINT32                      => 3;
use constant CT_INT64                       => 4;
use constant CT_UINT64                      => 5;
use constant CT_FLOAT32                     => 6;
use constant CT_FLOAT64                     => 7;
use constant CT_CHAR_PTR                    => 8;
use constant CT_BINARY_PTR                  => 9;
use constant CT_RSRC_HANDLE_PTR             => 10;
use constant CT_SD_PTR                      => 11;
use constant CT_SBS_PTR                     => 12;
use constant CT_INT32_ARRAY                 => 13;
use constant CT_UINT32_ARRAY                => 14;
use constant CT_INT64_ARRAY                 => 15;
use constant CT_UINT64_ARRAY                => 16;
use constant CT_FLOAT32_ARRAY               => 17;
use constant CT_FLOAT64_ARRAY               => 18;
use constant CT_CHAR_PTR_ARRAY              => 19;
use constant CT_BINARY_PTR_ARRAY            => 20;
use constant CT_RSRC_HANDLE_PTR_ARRAY       => 21;
use constant CT_SD_PTR_ARRAY                => 22;

# ct_sbs_field_data_type_t (TODO: any values assigned in ct.h yet?)
use constant CT_SF_INT32                    => 0;
use constant CT_SF_FLOAT32                  => 1;
use constant CT_SF_STRING                   => 2;
use constant CT_SF_BINARY                   => 3;

# ct_contact_type_t (TODO: any values assigned in ct.h yet?)
use constant CT_CONTACT_IP                  => 0;
use constant CT_CONTACT_ENV_VAR             => 1;
use constant CT_CONTACT_LOCAL               => 2;


$VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
    if ($! =~ /Invalid/) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
    }
    else {
        croak "Your vendor has not defined CT macro $constname";
    }
    }
    *$AUTOLOAD = sub () { $val };
    goto &$AUTOLOAD;
}

bootstrap CT::CT $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__


=head1 NAME

CT::CT - Perl extensions for RSCT ct.h


=head1 SYNOPSIS

use CT::CT;


=head1 DESCRIPTION

This extension is used by the Reliable Scalable Cluster Technology
(RSCT) Management Commands.
This includes the Resource Monitoring and Control (RMC) 
Command Line Interface.
RMC Commands are located in /usr/sbin/rsct/bin.
Some of the RMC commands are: lsrsrc, lsrsrcdef, mkrsrc, rmrsrc, chrsrc,
refrsrc, and lsactdef.

The Perl to C Extensions for the RSCT Cluster Technology (CT) layer,
CT::CT, are not being externalized at this time.
Use at your own risk!
The API to these extensions will probably change.


=head1 EXPORTED CONSTANTS

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct.h

    CT_UNKNOWN
    CT_NONE
    CT_INT32
    CT_UINT32
    CT_INT64
    CT_UINT64
    CT_FLOAT32
    CT_FLOAT64
    CT_CHAR_PTR
    CT_BINARY_PTR
    CT_RSRC_HANDLE_PTR
    CT_SD_PTR
    CT_SBS_PTR
    CT_INT32_ARRAY
    CT_UINT32_ARRAY
    CT_INT64_ARRAY
    CT_UINT64_ARRAY
    CT_FLOAT32_ARRAY
    CT_FLOAT64_ARRAY
    CT_CHAR_PTR_ARRAY
    CT_BINARY_PTR_ARRAY
    CT_RSRC_HANDLE_PTR_ARRAY
    CT_SD_PTR_ARRAY

    CT_SF_INT32
    CT_SF_FLOAT32
    CT_SF_STRING
    CT_SF_BINARY

    CT_CONTACT_IP
    CT_CONTACT_ENV_VAR
    CT_CONTACT_LOCAL


=head1 EXPORTED TAGS

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct.h 

ct_data_type_t => [qw(
    CT_UNKNOWN
    CT_NONE
    CT_INT32
    CT_UINT32
    CT_INT64
    CT_UINT64
    CT_FLOAT32
    CT_FLOAT64
    CT_CHAR_PTR
    CT_BINARY_PTR
    CT_RSRC_HANDLE_PTR
    CT_SD_PTR
    CT_SBS_PTR
    CT_INT32_ARRAY
    CT_UINT32_ARRAY
    CT_INT64_ARRAY
    CT_UINT64_ARRAY
    CT_FLOAT32_ARRAY
    CT_FLOAT64_ARRAY
    CT_CHAR_PTR_ARRAY
    CT_BINARY_PTR_ARRAY
    CT_RSRC_HANDLE_PTR_ARRAY
    CT_SD_PTR_ARRAY
)],

ct_sbs_field_data_type_t => [qw(
    CT_SF_INT32
    CT_SF_FLOAT32
    CT_SF_STRING
    CT_SF_BINARY
)],

ct_contact_type_t => [qw(
    CT_CONTACT_IP
    CT_CONTACT_ENV_VAR
    CT_CONTACT_LOCAL
)],


=head1 EXPORTED FUNCTIONS

TODO: Need to update with functions from ct_typemap.c


=head1 AUTHOR

Licensed Materials - Property of IBM

(C) COPYRIGHT International Business Machines Corp. 1998, 2001.
All Rights Reserved.

US Government Users Restricted Rights - Use, duplication or
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.


=head1 VERSION

RSCT Version 2.2 


=head1 SEE ALSO

rmccli

=cut
